# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 10
# Experiment: PMxPM, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"  # Initial move: Cooperate to signal willingness for mutual cooperation
    
    opponent_code_lower = opponent_program_code.lower()
    
    # Check for deterministic opponent strategies
    if "always cooperate" in opponent_code_lower or "return 'c'" in opponent_code_lower:
        return "D"  # Exploit always-cooperate
    if "always defect" in opponent_code_lower or "return 'd'" in opponent_code_lower:
        return "C"  # Minimize losses against always-defect
    
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Late-game: defect in last 2 rounds
    if current_round >= total_rounds - 1:
        return "D"
    
    # Mid-game adaptation
    if len(opp_history) >= 2:
        last_two_opp = opp_history[-2:]
        if last_two_opp == ["C", "C"]:
            return "C"
        elif last_two_opp == ["D", "D"]:
            return "D"
        elif opp_history[-1] == "D" and opp_history[-2] == "C":
            return "C"  # Forgive single defection after cooperation
    
    # Default: Tit-for-Tat (mirror last move)
    return opp_history[-1]